setwd("<your directory or folder path>")
df1 <- read.csv("20180701 Example 11.2 BMA v.2.csv")
#
#
#  need to execute library(nnet) once during R  session
library(BMA)
library(glmulti)
library(nnet)

#
# VARIABLES:
# X.01
# X.02
# X.03
# X.04
# X.05
# X.06
# X.07
# X.08
# X.09
# X.10
# Response
#
nbin <- nrow(df1)
testind <- rbinom(n=nbin,size=1,prob=0.1) 

df2 <- data.frame(cbind(df1,testind))

attach(df2)
dftest <- subset(df2,testind==1)
dftrain <- subset(df2,testind==0)


#
detach(df2)
attach(dftrain)
reg.names <- c("X.01","X.02","X.03","X.04","X.05","X.06","X.07","X.08","X.09","X.10")
nnet.model <- nnet(Response~X.01+X.02+X.03+X.04+X.05+X.06+X.07+X.08+X.09+X.10,data=dftrain,size=5,skip=TRUE,linout=TRUE)
lm.model <- lm(Response~X.01+X.02+X.03+X.04+X.05+X.06+X.07+X.08+X.09+X.10,data=dftrain)
step.model <- step(lm.model)
#
#
reg.names <- c("X.01","X.02","X.03","X.04","X.05","X.06","X.07","X.08","X.09","X.10")
prior.p <- c(0.9,0.001,0.9,0.001,0.001,0.9,0.9,0.9,0.9,0.001)
bma.model <- bic.glm(f=Response ~ X.01 + X.02 + X.03 + X.04 + X.05 + X.06 + X.07 + X.08 + X.09 + X.10,data=dftrain,glm.family=gaussian(),prior.param=prior.p)
#nnet.model <- nnet(Binary~X.01+X.02+X.03+X.04+X.05+X.06+X.07+X.08+X.09+X.10,data=dftrain,size=5,skip=TRUE,linout=TRUE)
#glm.model <- glm(Binary~X.01+X.02+X.03+X.04+X.05+X.06+X.07+X.08+X.09+X.10,family=binomial(link="logit"),data=dftrain)
#step.model <- step(glm.model)
multi.model <- glmulti(lm.model,plotty=FALSE,report=FALSE,level=1,maxsize=10,method="g")


#
#
# Make some plots:
nnet.predict <- nnet.model$fitted.values
step.predict <- step.model$fitted.values
lm.predict <- lm.model$fitted.values

plot(x=dftrain$Response,y=nnet.predict,pch=1,xlab="Observed",ylab="Predicted",main="Predicted Response vs. Observed")
points(x=dftrain$Response,y=step.predict,pch=2)
points(x=dftrain$Response,y=lm.predict,pch=3)
points(x=dftrain$Response,y=dftrain$Response,pch=4,type="b")
legend(x=-5,y=150,legend=c("NNET","STEPWISE","OLS LM","Observed Response"),pch=c(1,2,3,4))
#
# dev.new() allows more plots to be made without overwriting previous plots
#
#summary(lm.model)
lm.coeffs <- lm.model$coefficients
step.coeffs <- step.model$coefficients
#multi.params <- coefficients(multi.model)
#multi.coeffs <- multi.params[,1]
detach(dftrain)
attach(dftest)
OOS.nnet <- predict(nnet.model,dftest)
OOS.lm <- predict(lm.model,newdata=dftest)
OOS.step <- predict(step.model,newdata=dftest)
#OOS.lm <- lm.coeffs[1] + lm.coeffs[2]*X.01 + lm.coeffs[3]*X.02 + lm.coeffs[4]*X.03 + lm.coeffs[5]*X.04 + lm.coeffs[6]*X.05 + lm.coeffs[7]*X.06 + lm.coeffs[8]*X.07 + lm.coeffs[9]*X.08 + lm.coeffs[10]*X.09 + lm.coeffs[11]*X.10
#OOS.step <- step.coeffs[1] + step.coeffs[2]*X.01 + 0.0*X.02 + step.coeffs[3]*X.03 + 0.0*X.04 + 0.0*X.05 + step.coeffs[4]*X.06 + step.coeffs[5]*X.07 + step.coeffs[6]*X.08 + step.coeffs[7]*X.09 + 0.0*X.10
OOS.bma <- predict(bma.model,newdata=dftest)
OOS.multi <- predict(multi.model,newdata=dftest)
dev.new()
plot(x=dftest$Response,y=OOS.nnet,pch=1,xlab="Observed",ylab="Predicted",main="OOS Predicted Response vs. Observed")
points(x=dftest$Response,y=OOS.step,pch=2)
points(x=dftest$Response,y=OOS.lm,pch=3)
points(x=dftest$Response,y=OOS.bma,pch=4)
points(x=dftest$Response,y=OOS.multi$averages,pch=5)
points(x=dftest$Response,y=dftest$Response,pch=6,type="b")
legend(x=0,y=115,legend=c("NNET","STEPWISE","OLS LM","BMA","GLMULTI","Observed Response"),pch=c(1,2,3,4,5,6))

rmse.lm <- sqrt(mean(dftest$Response - OOS.lm)**2)
rmse.nnet <- sqrt(mean(dftest$Response - OOS.nnet)**2)
rmse.step <- sqrt(mean(dftest$Response - OOS.step)**2)
rmse.bma <- sqrt(mean(dftest$Response - OOS.bma)**2)
rmse.multi <- sqrt(mean(dftest$Response - OOS.multi$averages)**2)

